@rem *** This batch file only makes solid RGB textures by use of the
@rem *** quantizeRGB() command. If you want another type of texture, you'll
@rem *** have to modify the batch file yourself, or make a new one.

@rem --- Set this to the desired name of the output palette
@set PALETTENAME=%1

@rem --- Set this to the desired palette key
@set PALETTEKEY=%2

@rem --- Some parameters for picaNew
@set DIRECTORY=CUSTOM
@set RENDERSTART=1
@set RENDEREND=254

@echo off

rem --- Make sure the temporary files doesn't already exist
 del temp.pca

rem --- Write the parameters into the temporary file
 echo quantizeRGB() >> temp.pca
 echo outputPath(8bit) >> temp.pca
 echo paletteKey(%PALETTEKEY%) >> temp.pca
 echo palOutputName(palettes\ipl\%PALETTENAME%.ipl) >> temp.pca
 echo chooseRange(%RENDERSTART%, %RENDEREND%) >> temp.pca
 echo renderRange(%RENDERSTART%, %RENDEREND%) >> temp.pca
 echo extrudeMipLevels() >> temp.pca
 echo enforcePhoenixSave() >> temp.pca
 echo bitmapListStart() >> temp.pca
 echo 24bit\%DIRECTORY%\*.bmp >> temp.pca

rem --- Begin conversion to Phoenix bitmap and output the new palette.
 picanew -v4 @temp.pca

rem --- Cleanup
 del temp.pca